using System;
using System.Data;
using gov.va.med.vbecs;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.ExceptionManagement;
using System.Reflection;
using ANTIBODYPARAMETER = gov.va.med.vbecs.Common.VbecsTables.AntibodyParameter;
using ANTIBODYTYPE = gov.va.med.vbecs.Common.VbecsTables.AntibodyType;

namespace gov.va.med.vbecs.BOL
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/17/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Antibody Type business object layer class
		///</summary>

		#endregion


	public class AntibodyType
	{

		#region Variables 

		//Stores the object information
		private DataTable _antibodyTypeDataTable;
		private DataRow _antibodyTypeDataRow;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/24/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="293"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Antibody Type object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="294"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///		
		/// <summary>
		/// Blank Constructor. Does absolutely nothing.
		/// </summary>
		public AntibodyType()
		{
			//Create empty instances of the local storage variables
			this._antibodyTypeDataTable = new System.Data.DataTable(ANTIBODYTYPE.TableName);
			
			this._antibodyTypeDataTable.Columns.Add(ANTIBODYTYPE.AntibodyTypeId, typeof(int));
			this._antibodyTypeDataTable.Columns.Add(ANTIBODYTYPE.AntibodyTypeName, typeof(string));

			this._antibodyTypeDataRow = this._antibodyTypeDataTable.NewRow();
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/24/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="295"> 
		///		<ExpectedInput>AntibodyTypeId</ExpectedInput>
		///		<ExpectedOutput>Antibody Type object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="297"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///	
		/// <summary>
		/// Constructor by antibody type id
		/// </summary>
		/// <param name="antibodyTypeID"></param>
		public AntibodyType(int antibodyTypeID)
		{
			this.GetAntibodyTypeData(antibodyTypeID);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/24/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="298"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>Antibody Type object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="299"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///	
		/// <summary>
		/// Constructor by DataRow
		/// </summary>
		public AntibodyType(DataRow dataRow)
		{
			this.LoadFromDataRow(dataRow);
		}


		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/24/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="300"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>Antibody Type ID value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="305"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///	
		/// <summary>
		/// Antibody Type ID
		/// </summary>
		public int AntibodyTypeId
		{
			get
			{
				if (this._antibodyTypeDataRow.IsNull(ANTIBODYTYPE.AntibodyTypeId))
					return int.MinValue;

				return (int)this._antibodyTypeDataRow[ANTIBODYTYPE.AntibodyTypeId];
			}
			set
			{
				this._antibodyTypeDataRow[ANTIBODYTYPE.AntibodyTypeId] = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/24/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="307"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>Antibody Type Name value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="308"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///	
		/// <summary>
		/// Antibody Type Name
		/// </summary>
		public string AntibodyTypeName
		{
			get
			{
				if (this._antibodyTypeDataRow.IsNull(ANTIBODYTYPE.AntibodyTypeName))
					return string.Empty;

				return this._antibodyTypeDataRow[ANTIBODYTYPE.AntibodyTypeName].ToString();
			}
			set
			{
				this._antibodyTypeDataRow[ANTIBODYTYPE.AntibodyTypeName] = value;
			}
		}

		#endregion

		#region Methods

		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dataRow">Data row</param>
		protected void LoadFromDataRow(DataRow dataRow)
		{
			_antibodyTypeDataRow = dataRow;
		}

		/// <summary>
		/// Gets Antibody type data to load an instance of this class with
		/// </summary>
		/// <param name="antibodyTypeID"></param>
		private void GetAntibodyTypeData(int antibodyTypeID)
		{
			this._antibodyTypeDataTable = DAL.AntibodyType.GetAntibodyType(antibodyTypeID);

			if (_antibodyTypeDataTable.Rows.Count > 0) 
			{
				this._antibodyTypeDataRow = this._antibodyTypeDataTable.Rows[0];
			}
			else
			{
				this._antibodyTypeDataRow = this._antibodyTypeDataTable.NewRow();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/11/2002</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="562"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="214"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Static method to return a data table of active collection facilities. Can be used to populate a combobox. 
		/// To have a blank row in the table pass in a true value.
		/// BR_38.03
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntibodyTypeLookupList()
		{
			return(DAL.AntibodyType.GetAntibodyTypeLookupList());
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/28/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7262"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7263"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetCompleteAntibodyTypeList
		/// </summary>
		/// <returns></returns>
		public static DataTable GetCompleteAntibodyTypeList()
		{
			return(DAL.AntibodyType.GetCompleteAntibodyTypeList());
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6185"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6186"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// Get the list of antibodies without including antigen information
		///</summary>
		public static DataTable GetAntibodiesWithoutAntigens()
		{
			return(DAL.AntibodyType.GetAntibodiesWithoutAntigens());
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3310"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="215"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a data table of AntibodyTypes
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntibodyType()
		{
			return(DAL.AntibodyType.GetAntibodyType());
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1421"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2127"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable of blood units with the antibody type and division code
		/// </summary>
		/// <param name="antibodyTypeId"></param>
		/// <returns></returns>
		public static DataTable GetBloodUnitsWithAntibodyType(int antibodyTypeId)
		{
			return(DAL.AntibodyType.GetBloodUnitsWithAntibodyType(antibodyTypeId));
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1422"> 
		///		<ExpectedInput>Valid DataTable</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2128"> 
		///		<ExpectedInput>Null Datatable</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Saves a DataTable of antibodies
		/// </summary>
		/// <param name="dtAntibodies"></param>
		/// <param name="lastUpdateFunctionId">UC or Function peforming this call</param>
		/// <returns></returns>
		public static bool SaveAntibodyTypes(DataTable dtAntibodies, Common.UpdateFunction lastUpdateFunctionId)
		{
			DataTable dtAntibodiesForUpdate = new DataTable();
			DataRow drAntibodyForUpdate;
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.AntibodyTypeId, typeof(int));
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.HigherLevelOverrideIndicator, typeof(bool));
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.CompatibilityPercentage, typeof(short));
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.DivisionCode);
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.RowVersion, typeof(byte[]));
			dtAntibodiesForUpdate.Columns.Add(ANTIBODYPARAMETER.LastUpdateFunctionId, typeof(int));

			DataTable dtAntibodyChanges = dtAntibodies.GetChanges(DataRowState.Modified);

			if (dtAntibodyChanges != null)
			{
				foreach(DataRow drAntibody in dtAntibodyChanges.Rows)
				{
					drAntibodyForUpdate = dtAntibodiesForUpdate.NewRow();
					drAntibodyForUpdate[ANTIBODYPARAMETER.AntibodyTypeId] = drAntibody[ANTIBODYTYPE.AntibodyTypeId];
					drAntibodyForUpdate[ANTIBODYPARAMETER.HigherLevelOverrideIndicator] = drAntibody[ANTIBODYPARAMETER.HigherLevelOverrideIndicator];
					drAntibodyForUpdate[ANTIBODYPARAMETER.CompatibilityPercentage] = drAntibody[ANTIBODYPARAMETER.CompatibilityPercentage];
					drAntibodyForUpdate[ANTIBODYPARAMETER.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
					drAntibodyForUpdate[ANTIBODYPARAMETER.RowVersion] = drAntibody[ANTIBODYPARAMETER.RowVersion];
					drAntibodyForUpdate[ANTIBODYPARAMETER.LastUpdateFunctionId] = (int)lastUpdateFunctionId;
					dtAntibodiesForUpdate.Rows.Add(drAntibodyForUpdate);
				}
				return DAL.AntibodyType.SaveAntibodyTypes(dtAntibodiesForUpdate);
			}
			else
			{
				return false;
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3311"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="216"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable representing the AntigenTest reference table.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntigenTest()
		{
			return DAL.AntibodyType.GetAntigenTest();
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/28/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7264"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7265"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetAntibodiesForAntigenType
		/// </summary>
		/// <param name="antigenTypeId"></param>
		/// <returns></returns>
		public static DataTable GetAntibodiesForAntigenType(int antigenTypeId)
		{
			return(DAL.AntibodyType.GetAntibodiesForAntigenType(antigenTypeId));
		}

		#endregion

	}
}

